//								EJEMPLO 9
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
//La interrupcin del TMR0.
//
//Se trata de comprobar la interrupcin provocada por el TMR0. El programa
//lee el estado de los interruptores conectados a RA0 y RA1 para reflejarlo en
//los leds conectados a RB0 y RB1 respectivamente. Al mismo tiempo el TMR0
//genera una interrupcin cada 0.01 seg. (10 mS) que se repetir 50 veces con objeto 
//de hacer intermitencia de 500 mS sobre el led conectado a RB7.

#include <16f876A.h>

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use delay(clock=4000000) //Activa las temporizaciones en base al clock de trabajo
#use fast_io (A)
#use fast_io (B)

#byte port_a = 5
#byte port_b = 6

static int cont=50;		//La temporizacin de 10mS se repite 50 veces

#INT_RTCC				//Inicio del tratamiento de la interrupcin del TMR0	
Tratamiento_TMR0()		// Funcin de tratamiento de interrupcin para el TMR0
{
  set_rtcc(~39);		// Cargar TMR0 con 39 para 10mS
  cont--;
  if(!cont)				//Se ha repetido 50 veces (0.5s) ??
  {
    cont=50;
  	port_b=(port_b ^ 0x80); //Si, cambio de estado en RB7
  }   
}

main()
{  
	setup_adc_ports(NO_ANALOGS);	//Puerta A digital
  	set_tris_a(0x3F);				//Puerta A entrada
  	set_tris_b(0x00);				//Puerta B salida
	  	   
	setup_counters(RTCC_INTERNAL,RTCC_DIV_256);	// TMR0 interno con preescaler de 256
  	set_rtcc(~39);					// Cargar el TMR0 con 39 (39*256*1=10mS)

  	enable_interrupts(INT_RTCC);	// Seleccionar interrupciones por rebasamiento de TMR0
 	enable_interrupts(GLOBAL);		// Activar interrupciones

  	while(1)
	 	{
 		if(bit_test(port_a,0))		//Lee el estado de RA0 y RA1
     	output_bit(PIN_B0,1); 		//y visualiza sobre RB0 y RB1
		else 
		output_bit(PIN_B0,0);
		if(bit_test(port_a,1))
		output_bit(PIN_B1,1);
		else 
		output_bit(PIN_B1,0);
		}
}	



